# Obtener la ruta de la carpeta donde se encuentra el script
$folderPath = Split-Path -Parent $MyInvocation.MyCommand.Path

# Obtener únicamente archivos .mscz en la carpeta
$files = Get-ChildItem -Path $folderPath -File -Filter "*.png"

# Definir un diccionario para reemplazar caracteres acentuados
$replacements = @{
    'á' = 'a'
    'é' = 'e'
    'í' = 'i'
    'ó' = 'o'
    'ú' = 'u'
}

# Iterar sobre cada archivo .mscz
foreach ($file in $files) {
    # Obtener el nombre del archivo sin la extensión
    $fileName = [System.IO.Path]::GetFileNameWithoutExtension($file.Name)
    # Obtener la extensión del archivo
    $fileExtension = $file.Extension

    # Eliminar sufijos __1 y _-1
    $fileName = $fileName -replace '(__1|_-1|_1)$', ''

    # Eliminar prefijos "Himno_" o "Himno__"
    $fileName = $fileName -replace '^(Himno__?|Himno_?)', ''

    # Reemplazar caracteres acentuados
    foreach ($key in $replacements.Keys) {
        $fileName = $fileName -replace [regex]::Escape($key), $replacements[$key]
    }

    # Reemplazar guiones por guiones bajos
    $fileName = $fileName -replace '-', '_'

    # Reemplazar espacios con guiones bajos
    $fileName = $fileName -replace '\s', '_'

    # Eliminar números
    $fileName = $fileName -replace '\d', ''

    # Eliminar caracteres no alfanuméricos (excepto el guion bajo, el punto y la letra ñ)
    $fileName = $fileName -replace '[^a-z0-9_.ñ]', ''

    # Eliminar guion bajo al final del nombre
    $fileName = $fileName -replace '_$', ''

    # Convertir a minúsculas
    $newFileName = $fileName.ToLower()

    # Crear el nuevo nombre completo
    $newFullName = [System.IO.Path]::Combine($folderPath, $newFileName + $fileExtension)

    if ($file.Name -cmatch '[A-Z]'){
        Write-Host "Lleva mayúsculas $newFileName"
    }


    # Renombrar el archivo si el nuevo nombre es diferente (sin convertir el original a minúsculas)
    if (($newFullName -ne $file.FullName) -or ($file.Name -cmatch '[A-Z]')) {
        try {
            Write-Host "Renombrando '$($file.Name)' por '$newFileName$fileExtension'"

            Rename-Item -Path $file.FullName -NewName $newFullName
        } catch {
            Write-Host "Error al renombrar el archivo: '$($file.FullName)'"
            Write-Host "Nuevo nombre propuesto: '$newFullName'"
        }
    }
}

Write-Host "Renombrado completado."
